import tkinter as tk
from tkinter import ttk, messagebox, StringVar, Text, DISABLED, NORMAL
import sqlite3
from datetime import datetime
from fpdf import FPDF
import customtkinter as ctk
import time
from spellchecker import SpellChecker
import tkinter as tk
from tkinter import messagebox
import openai

import tkinter as tk
from tkinter import messagebox
# Liste aller Berufe in Deutschland direkt im Python-Code
berufe = [
    # A
    "Änderungsschneider/in", "Agrarservicefachkraft", "Altenpflegehelfer/in", "Altenpfleger/in",
    "Anästhesietechnische/r Assistent/in", "Anlagenmechaniker/in", 
    "Anlagenmechaniker/in für Sanitär-, Heizungs- und Klimatechnik", "Architekt/in", 
    "Arzthelfer/in", "Asphaltbauer/in", "Augenoptiker/in", "Ausbaufacharbeiter/in", 
    "Automatenfachmann/-frau", "Automobilkaufmann/-frau", "Automobilmechaniker/in",

    # B
    "Bäcker/in", "Bankkaufmann/-frau", "Baugeräteführer/in", "Baustoffprüfer/in",
    "Bauten- und Objektbeschichter/in", "Bauwerksabdichter/in", "Bauzeichner/in",
    "Behälter- und Apparatebauer/in", "Berufskraftfahrer/in", "Bestattungsfachkraft",
    "Beton- und Stahlbetonbauer/in", "Betonfertigteilbauer/in", "Binnenschiffer/in",
    "Biologielaborant/in", "Bodenleger/in", "Brauer/in und Mälzer/in", 
    "Buchbinder/in", "Buchhändler/in", "Büchsenmacher/in", "Bürokaufmann/-frau",

    # C
    "Chemielaborant/in", "Chemikant/in", "Chirurgiemechaniker/in",

    # D
    "Dachdecker/in", "Datenschutzbeauftragte/r", "Destillateur/in", "Drechsler/in", 
    "Drogist/in",

    # E
    "Edelmetallprüfer/in", "Edelsteinfasser/in", "Edelsteinschleifer/in",
    "Eisenbahner/in im Betriebsdienst", "Elektriker/in", 
    "Elektroniker/in für Automatisierungstechnik", "Elektroniker/in für Betriebstechnik", 
    "Elektroniker/in für Energie- und Gebäudetechnik", 
    "Elektroniker/in für Geräte und Systeme", 
    "Elektroniker/in für Informations- und Systemtechnik", 
    "Elektroniker/in für Maschinen und Antriebstechnik", 
    "Estrichleger/in", "Erzieher/in", "Eventmanager/in",

    # F
    "Fachangestellte/r für Arbeitsmarktdienstleistungen", "Fachangestellte/r für Bäderbetriebe",
    "Fachangestellte/r für Markt- und Sozialforschung", "Fachangestellte/r für Medien- und Informationsdienste",
    "Fachinformatiker/in für Anwendungsentwicklung", "Fachinformatiker/in für Systemintegration",
    "Fachkraft für Abwassertechnik", "Fachkraft für Agrarservice",
    "Fachkraft für Fruchtsafttechnik", "Fachkraft für Gastronomie", 
    "Fachkraft für Hafenlogistik", "Fachkraft für Holz- und Bautenschutzarbeiten",
    "Fachkraft für Kreislauf- und Abfallwirtschaft", "Fachkraft für Kurier-, Express- und Postdienstleistungen",
    "Fachkraft für Lagerlogistik", "Fachkraft für Lebensmitteltechnik",
    "Fachkraft für Metalltechnik", "Fachkraft für Rohr-, Kanal- und Industrieservice", 
    "Fahrzeuglackierer/in", "Feinoptiker/in", "Feinwerkmechaniker/in", 
    "Fleischer/in", "Florist/in", "Fluggerätmechaniker/in", 
    "Fluggerätelektroniker/in", "Fotograf/in", "Friseur/in", 

    # G
    "Gebäudereiniger/in", "Geigenbauer/in", "Geomatiker/in", 
    "Gießereimechaniker/in", "Glasbläser/in", "Glas- und Porzellanmaler/in", 
    "Glaser/in", "Goldschmied/in", "Graveur/in", "Gärtner/in",
    "Gestalter/in für visuelles Marketing",

    # H
    "Hauswirtschafter/in", "Hotelfachmann/-frau", "Holzblasinstrumentenmacher/in", 
    "Holzmechaniker/in", "Hörakustiker/in",

    # I
    "Immobilienkaufmann/-frau", "Industriemechaniker/in", "Industriekaufmann/-frau",
    "Informatikkaufmann/-frau", "Informationselektroniker/in", "IT-System-Elektroniker/in",

    # J
    "Juwelengoldschmied/in", "Juwelier/in",

    # K
    "Kaufmann/-frau für Büromanagement", "Kaufmann/-frau für Einzelhandel",
    "Kaufmann/-frau im E-Commerce", "Kaufmann/-frau für Spedition und Logistikdienstleistung",
    "Koch/Köchin", "Konditor/in", "Kosmetiker/in", "Kraftfahrzeugmechatroniker/in",

    # L
    "Landwirt/in", "Landschaftsgärtner/in", "Lacklaborant/in",

    # M
    "Maler/in und Lackierer/in", "Maurer/in", "Mechatroniker/in",
    "Mediengestalter/in Digital und Print", "Medizinische/r Fachangestellte/r",
    "Metallbauer/in", "Milchtechnologe/in",

    # N
    "Naturwerksteinmechaniker/in", "Notarfachangestellte/r",

    # O
    "Oberflächenbeschichter/in", "Orthopädietechniker/in",

    # P
    "Packmitteltechnologe/in", "Pferdewirt/in", "Pharmazeutisch-technische/r Assistent/in",
    "Pflegefachmann/-frau", "Physiklaborant/in",

    # R
    "Raumausstatter/in", "Restaurantfachmann/-frau", "Rohrleitungsbauer/in",

    # S
    "Sattler/in", "Schilder- und Lichtreklamehersteller/in", "Schlosser/in",
    "Schornsteinfeger/in", "Schreiner/in", "Sozialversicherungsfachangestellte/r",
    "Steuerfachangestellte/r", "Systemgastronom/in",

    # T
    "Tischler/in", "Tierpfleger/in", "Trockenbaumonteur/in",

    # U
    "Uhrmacher/in", "Umweltschutztechniker/in",

    # V
    "Verfahrensmechaniker/in für Kunststoff- und Kautschuktechnik",
    "Verpackungsmittelmechaniker/in", "Verkäufer/in",

    # W
    "Wasserbauer/in", "Weintechnologe/in", "Werkzeugmechaniker/in",
    "Winzer/in", "Wirtschaftsinformatiker/in",

    # Z
    "Zahntechniker/in", "Zerspanungsmechaniker/in", "Zimmerer/Zimmerin", 
    "Zweiradmechatroniker/in"
]


# OpenAI-API-Schlüssel (initial leer)
api_key = "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"

# Funktion zum Speichern des API-Schlüssels
def save_api_key():
    global api_key
    key = api_key_entry.get()
    if key.strip():
        api_key = key.strip()
        messagebox.showinfo("Erfolg", "API-Schlüssel wurde gespeichert!")
    else:
        messagebox.showerror("Fehler", "Bitte einen gültigen API-Schlüssel eingeben.")

# Funktion zum Fortsetzen des Programms
def weiter_und_schließen():
    if not api_key:
        messagebox.showerror("Fehler", "Bitte den API-Schlüssel eingeben, bevor Sie fortfahren!")
        return
    login_window.destroy()
    start_main_program()

# Hauptprogramm nach Login

# Funktion zur Textgenerierung mit OpenAI
def generiere_ki_text_mit_openai(name, praktikum, firma, ansprechpartner):
    if not api_key:
        messagebox.showerror("Fehler", "Bitte logge dich zuerst ein und speichere deinen API-Schlüssel.")
        return ""

    try:
        prompt = (
            f"Erstelle ein professionelles Bewerbungsschreiben für ein Praktikum. "
            f"Der Name des Bewerbers ist {name}. Der Praktikumsbereich ist {praktikum}. "
            f"Die Bewerbung richtet sich an die Firma {firma} und den Ansprechpartner {ansprechpartner}."
        )
        response = openai.Completion.create(
            engine="text-davinci-003",
            prompt=prompt,
            max_tokens=500,
            temperature=0.7
        )
        return response.choices[0].text.strip()
    except Exception as e:
        messagebox.showerror("Fehler", f"KI-Generierung fehlgeschlagen: {e}")
        return ""

# Deutsches Wörterbuch laden
spell = SpellChecker(language='de')


# Ladebildschirm-Funktion
def ladebildschirm():
    root = tk.Tk()
    root.title("Ladebildschirm")
    root.geometry()
    root.configure(bg="#2E2E2E")  # Dunkelgrauer Hintergrund


    # Lade-Label
    lade_label = tk.Label(root, text="Wird geladen...", font=("Helvetica", 16), fg="white", bg="#2E2E2E")
    lade_label.pack(pady=40)  # Abstand zum Ladebalken


    # Ladebalken
    ladebalken = ttk.Progressbar(root, orient="horizontal", length=400, mode="determinate", maximum=100)
    ladebalken.pack(pady=20)  # Abstand zum Text


    # Lade-Logik
    def lade():
        for i in range(101):
            time.sleep(0.03)  # Wartezeit simulieren
            ladebalken["value"] = i
            root.update_idletasks()  # Updates das UI
        root.destroy()  # Schließt das Fenster nach dem Laden


    root.after(100, lade)  # Starte die Ladeanimation nach 100ms
    root.mainloop()

# Ladebildschirm anzeigen, bevor das Hauptprogramm startet
ladebildschirm()

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()

# Erstelle Tabelle, falls sie nicht vorhanden ist
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()

# Autokorrektur: Wörter markieren
def autokorrektur_markieren(event, text_widget):
    text_widget.tag_remove("falsch", "1.0", "end")  # Entfernt alte Markierungen
    text = text_widget.get("1.0", "end-1c")  # Gesamten Text abrufen
    worte = text.split()  # Text in Wörter aufteilen

    for wort in worte:
        if wort not in spell and spell.candidates(wort):  # Wort ist falsch geschrieben
            start_index = text_widget.search(wort, "1.0", stopindex="end")
            if start_index:
                end_index = f"{start_index}+{len(wort)}c"
                text_widget.tag_add("falsch", start_index, end_index)  # Markiere das Wort
                text_widget.tag_config("falsch", foreground="red")  # Rot markieren

# Korrektur-Button: Falsche Wörter korrigieren
def korrigieren(text_widget):
    text = text_widget.get("1.0", "end-1c")
    worte = text.split()

    for wort in worte:
        if wort not in spell and spell.candidates(wort):
            korrekturen = list(spell.candidates(wort))
            if korrekturen:
                korrektur = korrekturen[0]
                text = text.replace(wort, korrektur)

    text_widget.delete("1.0", "end")
    text_widget.insert("1.0", text)
# Funktion zur Bestimmung der Anrede (Dummy-Funktion, falls erforderlich)
def determine_anrede(ansprechpartner):
    """
    Automatische Gendererkennung basierend auf dem Namen des Ansprechpartners.
    """
    if not ansprechpartner.strip():
        return "Sehr geehrte Damen und Herren"
    
    anrede = "Sehr geehrte/r"
    
    # Typische Namensendungen für eine einfache Gendererkennung
    weibliche_endungen = ["a", "e", "ine", "ung", "heit", "keit", "in"]
    maennliche_endungen = ["er", "el", "us", "en", "on", "mann"]
    
    name_lower = ansprechpartner.strip().lower()
    
    if any(name_lower.endswith(endung) for endung in weibliche_endungen):
        anrede = "Sehr geehrte Frau"
    elif any(name_lower.endswith(endung) for endung in maennliche_endungen):
        anrede = "Sehr geehrter Herr"
    
    return anrede

def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()  # Beruf aus dem Dropdown
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    if not name or not firma or not telefon:
        messagebox.showwarning("Eingabefehler", "Bitte alle Felder ausfüllen!")
        return
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum im Bereich {praktikum}"
    nachricht = result_text.get("1.0", "end-1c")
    now = datetime.now()

    try:
        c.execute('''
            INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, now))
        conn.commit()
        messagebox.showinfo("Erfolg", "Bewerbung erfolgreich gespeichert!")
    except Exception as e:
        messagebox.showerror("Datenbankfehler", f"Fehler beim Speichern der Bewerbung:\n{e}")

    
# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    dateiname = f"bewerbung_{datetime.now().strftime('%Y%m%d_%H%M%S')}.pdf"
    pdf.output(dateiname)
    messagebox.showinfo("Erfolg", f"PDF wurde gespeichert als {dateiname}!")

def oeffne_in_outlook():
    try:
        outlook = win32com.client.Dispatch("Outlook.Application")
        mail = outlook.CreateItem(0)
        mail.Subject = f"Betreff: {result_text.get('1.0', '1.60')}"
        mail.Body = result_text.get('1.61', 'end-1c')
        mail.Display()
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler beim Öffnen von Outlook: {e}")
        
def zeige_historie_fenster():
    # Lösche alle Widgets im Frame
    for widget in frame.winfo_children():
        widget.destroy()

    # Neues Frame für Listbox und Scrollbar mit begrenzter Größe
    listbox_frame = tk.Frame(frame, width=400, height=500)
    listbox_frame.pack_propagate(False)  # Frame-Inhalt überschreibt nicht die Größe
    listbox_frame.pack(side="left", expand=True, padx=10, pady=10)

    # Scrollbar erstellen
    scrollbar = tk.Scrollbar(listbox_frame, orient="vertical")
    scrollbar.pack(side="left", fill="y")

    # Listbox erstellen und mit Scrollbar verbinden
    listbox = tk.Listbox(frame, font=("Helvetica", 12), yscrollcommand=scrollbar.set)
    listbox.pack(side="left", fill="y", expand=True)

    # Scrollbar mit der Listbox verbinden
    scrollbar.config(command=listbox.yview)



    # Datenbankabfrage für Historie
    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

    # Historieneinträge in die Listbox einfügen
    for b_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(listbox_frame, text=f"{b_id}: {firma} - {datum}",
                               command=lambda id=b_id: lade_bewerbung(id))
        button.pack(fill="y", pady=2)
        listbox.insert("end")

    # Detailanzeige bei Doppelklick
    def zeige_details(event):
        selected = listbox.curselection()
        if not selected:
            return
        index = selected[0]
        bewerbung_id = bewerbungen[index][0]  # ID des ausgewählten Eintrags

        # Detailabfrage
        c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (b_id,))
        result = c.fetchone()
        if result:
            betreff, nachricht = result
            messagebox.showinfo("Bewerbungsdetails", f"Betreff: {betreff}\n\n{nachricht}")

    # Doppelklick-Ereignis binden
    

    global text_area
    text_area = Text(frame, height=20, width=60, wrap="word", padx=10, pady=10, font=("Helvetica", 12))
    text_area.pack(side="top", fill="both", expand=True)

    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

    

    # Frame für die Buttons unterhalb des Textbereichs
    toolbar = ctk.CTkFrame(frame, fg_color="#e6f0fa")
    toolbar.pack(side="left", fill="x", padx=10, pady=10)

    # Button für Fett, Kursiv, Unterstrichen, Bewerbung, PDF mit gleicher Breite
    bold_button = ctk.CTkButton(toolbar, text="Fett", command=lambda: toggle_bold(text_area), width=15)
    bold_button.pack(side="left", padx=5)


    italic_button = ctk.CTkButton(toolbar, text="Kursiv", command=lambda: toggle_italic(text_area), width=15)
    italic_button.pack(side="left",fill="x", padx=5)


    underline_button = ctk.CTkButton(toolbar, text="Unterstreichen", command=lambda: toggle_underline(text_area), width=15)
    underline_button.pack(side="left", padx=5)


    pdf_button = ctk.CTkButton(toolbar, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")), width=15)
    pdf_button.pack(side="right", padx=5)


 # Bewerbung-Button im Historien-Frame (Start-Status: deaktiviert)
    global bewerbung_button
    bewerbung_button = ctk.CTkButton(toolbar, text="Bewerbung", font=("Helvetica", 14), state="disabled", command=lambda: zeige_bewerbung_inhalt(frame))
    bewerbung_button.pack(side="right", padx=5)

def zeige_bewerbung_inhalt(parent_frame):
    # Verwende vorhandenen Frame
    buttons_frame = ctk.CTkFrame(parent_frame)  # Nutzt den übergebenen Frame
    buttons_frame.pack(side="right", padx=10, pady=10, fill="y")

    # Buttons hinzufügen
    deckblatt_button = ctk.CTkButton(buttons_frame, text="Deckblatt", font=("Helvetica", 14), command=lambda: show_content("Deckblatt"))
    deckblatt_button.pack(fill="x", pady=5)

    motivationsschreiben_button = ctk.CTkButton(buttons_frame, text="Motivationsschreiben", font=("Helvetica", 14), command=lambda: show_content("Motivationsschreiben"))
    motivationsschreiben_button.pack(fill="x", pady=5)

    lebenslauf_button = ctk.CTkButton(buttons_frame, text="Lebenslauf", font=("Helvetica", 14), command=lambda: show_content("Lebenslauf"))
    lebenslauf_button.pack(fill="x", pady=5)

    # Funktion für die Anzeige der verschiedenen Dokumente
    def show_content(option):
        if option == "Deckblatt":
            content = f"Deckblatt für {name_entry.get()} - {firma_entry.get()}"
        elif option == "Motivationsschreiben":
            content = f"Motivationsschreiben von {name_entry.get()} - {firma_entry.get()}"
        else:
            content = f"Lebenslauf von {name_entry.get()} - {firma_entry.get()}"
        text_area_left.delete("1.0", "end")
        text_area_left.insert("1.0", content)

# Lade Bewerbung aus der Datenbank
def lade_bewerbung(bewerbung_id):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")
        bewerbung_button.configure(state="normal")  # Aktiviert den Bewerbung-Button, wenn ein Eintrag ausgewählt wurde

# Hauptfenster
app = ctk.CTk()
app.title("Bewerbungsassistent")
app.geometry()
app.configure(fg_color="#e6f0fa")



frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Beruf auswählen:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(10, 0))
beruf_var = ctk.StringVar(value="Bitte Beruf wählen")
beruf_dropdown = ctk.CTkOptionMenu(frame, variable=beruf_var, values=berufe, width=450)
beruf_dropdown.grid(row=3, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

result_text = Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

# Autokorrektur während der Eingabe aktivieren
result_text.bind("<KeyRelease>", lambda event: autokorrektur_markieren(event, result_text))

speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)

korrigieren_button = ctk.CTkButton(frame, text="Korrigieren", font=("Helvetica", 14), command=lambda: korrigieren(result_text))
korrigieren_button.grid(row=9, column=0, columnspan=1, pady=5)

outlook_button = tk.Button(frame, text="In Outlook öffnen", font=("Helvetica", 14), command=oeffne_in_outlook)
outlook_button.grid(row=9, column=0, columnspan=4, pady=15)




app.mainloop()
